<?php

namespace Forums\Data;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Channel extends Model 
{

    protected $table = 'channels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'slug', 'color', 'icon');

    public function conversations()
    {
        return $this->hasMany('Conversation');
    }

}